IF OBJECT_ID('P_EST_SNGPC_SAIDA_PERDA_INCLUIR') IS NOT NULL
    BEGIN
        DROP PROCEDURE P_EST_SNGPC_SAIDA_PERDA_INCLUIR;
END;
GO

CREATE PROCEDURE P_EST_SNGPC_SAIDA_PERDA_INCLUIR(@PCODIGOMOVPERDA INT
											   , @EMPRESA         INT
											   , @FILIAL          INT
											   , @CD_NF           INT
											   , @CD_PROD         INT
											   , @CD_IT           INT
											   , @PCODIGOLOTE     INT
											   , @PDATA           DATETIME
											   , @PQTDE           INT
											   , @PCODIGOUSUARIO  INT
											   , @PCODIGOMOTIVO   INT
											   , @PNUMAUTOPERDA   VARCHAR(50)
											   , @PVERSAO			VARCHAR(20))
AS
	 SET NOCOUNT ON; 
        DECLARE
                        @OUTTABLE TABLE (ID INT);     
	 DECLARE
			@CODIGO INT;
	 DECLARE
			@CODIGOLOTE INT;
	 DECLARE
			@DATA DATETIME;
	 DECLARE
			@QTDE INT;
	 DECLARE
			@ERROR VARCHAR(MAX);
	 DECLARE
			@OPERACAO VARCHAR(MAX);
	 SET @DATA = GETDATE();
	BEGIN TRY
		SELECT @QTDE = QT_LOTE
			 , @CODIGOLOTE = CD_LOTE
		FROM EST_SNGPC_SAIDA
		WHERE CD_SAI_SNGPC = @PCODIGOMOVPERDA;
		IF @QTDE IS NULL
			BEGIN
				SET @OPERACAO = 'INSERT MOV PERDA';
				INSERT INTO EST_SNGPC_SAIDA
				(CD_EMP
			   , CD_FILIAL
			   , CD_LOTE
			   , DT_MOV
			   , QT_LOTE
			   , DT_ULT_ALT
			   , CD_USU
				) OUTPUT INSERTED.CD_SAI_SNGPC  INTO @OUTTABLE(ID)
				VALUES
				(@EMPRESA
			   , @FILIAL
			   , @PCODIGOLOTE
			   , @PDATA
			   , @PQTDE
			   , @DATA
			   , @PCODIGOUSUARIO
				);
			 SET @CODIGO = (SELECT                                
                               MAX(ID)                                         
                            FROM @OUTTABLE                                     
                              );                                                  
				INSERT INTO EST_SNGPC_SAIDA_PERDA
				(CD_SAI_SNGPC
			   , CD_TP_PERDA
			   , NR_AUTO_PERDA
			   , DT_ULT_ALT
			   , CD_USU
				)
				VALUES
				(@CODIGO
			   , @PCODIGOMOTIVO
			   , @PNUMAUTOPERDA
			   , @DATA
			   , @PCODIGOUSUARIO
				);
				SET @QTDE = @PQTDE;
				IF @CD_NF > 0
					BEGIN
						INSERT INTO EST_SNGPC_SAIDA_PERDA_NF
						(CD_SAI_SNGPC
					   , CD_EMP
					   , CD_FILIAL
					   , CD_NF
					   , CD_PROD
					   , CD_IT
						)
						VALUES
						(@CODIGO
					   , @EMPRESA
					   , @FILIAL
					   , @CD_NF
					   , @CD_PROD
					   , @CD_IT
						);
					END;
			END;
		ELSE
			BEGIN
				SET @OPERACAO = 'UPDATE MOV PERDA';
				UPDATE EST_SNGPC_SAIDA
				  SET
					  CD_LOTE = @PCODIGOLOTE
					, DT_MOV = @PDATA
					, QT_LOTE = @PQTDE
					, DT_ULT_ALT = GETDATE()
					, CD_USU = @PCODIGOUSUARIO
				WHERE CD_SAI_SNGPC = @PCODIGOMOVPERDA;
				UPDATE EST_SNGPC_SAIDA_PERDA
				  SET
					  NR_AUTO_PERDA = @PNUMAUTOPERDA
					, CD_TP_PERDA = @PCODIGOMOTIVO
				WHERE CD_SAI_SNGPC = @PCODIGOMOVPERDA;
				IF @CODIGOLOTE <> @PCODIGOLOTE
					BEGIN
						UPDATE EST_PROD_EST_SNGPC_LOTE_CPL
						  SET
							  QT_LOTE = (QT_LOTE + @QTDE)
						WHERE CD_EMP = @EMPRESA
							  AND CD_FILIAL = @FILIAL
							  AND CD_LOTE = @CODIGOLOTE;
						SET @QTDE = @PQTDE;
					END;
				ELSE
					BEGIN
						SET @QTDE = @PQTDE - @QTDE;
					END;
				SET @CODIGO = @PCODIGOMOVPERDA;
			END;
		UPDATE EST_PROD_EST_SNGPC_LOTE_CPL
		  SET
			  QT_LOTE = (QT_LOTE - @QTDE)
		WHERE CD_EMP = @EMPRESA
			  AND CD_FILIAL = @FILIAL
			  AND CD_LOTE = @PCODIGOLOTE;
		UPDATE EST_SNGPC_SAIDA_PERDA_NF
		  SET
			  CD_EMP = @EMPRESA
		WHERE CD_SAI_SNGPC = @PCODIGOMOVPERDA;
		SELECT @DATA AS DT_ULT_ALT
			 , @CODIGO AS CD_SAI_SNGPC;
		INSERT INTO SNGPC_HIST_MOV_LOTE
				(CD_EMP
			   , CD_FILIAL
			   , CD_PROD
			   , LOTE
			   , TIPO_MOV
			   , CD_MOV
			   , DT_MOV
			   , CD_USU
			   , QT_MOV
			   , VERSAO
				)
		VALUES
			(@EMPRESA
		   , @FILIAL
		   , @CD_PROD  
		   , @PCODIGOLOTE
		   , @OPERACAO
		   , @PCODIGOMOVPERDA
		   , GETDATE()
		   , @PCODIGOUSUARIO
		   , @QTDE
		   , @PVERSAO			
			);
	END TRY
	BEGIN CATCH
       SET  @CODIGO =0;
		BEGIN TRY
			ROLLBACK;
		END TRY
		BEGIN CATCH
		END CATCH;
		SET @ERROR = ERROR_MESSAGE();
		RAISERROR(@ERROR, 16, 1);
	END CATCH;
SELECT @DATA AS DT_ULT_ALT
		  , @CODIGO AS CD_ENT_SNGPC;
GO